/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw;

import com.ibm.hsc.auiml.databeans.sfp.SFPUtil;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardFrameTasklet;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;

public class LaunchInfoCenter {
    private static final String TRACE_MASKD = "JLINFOCD";
    private static final String TRACE_MASKF = "JLINFOCF";
    private static final String TRACE_MASKT = "JLINFOCT";
    private static final String URL_FILE = "iphai/confighmcgs.htm#aftergs";
    private static final String WIZ_STATUS_FILE = "/opt/hsc/data/GuidedSetupWizard.status";
    private static final String WIZ_STATUS = "done";
    private static final int WEB_SERVER_PORT = 4411;
    private static final String WEB_BROWSER_OPTIONS = "-geometry 640x480+382+238";

    public static void main(String[] stringArray) {
        boolean bl = false;
        EExecResult eExecResult = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> LaunchInfoCenter.launchInfoCenter()");
        }
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- hostname/locale is " + string + "/" + string2);
            }
            if (bl = LaunchInfoCenter.waitForWebServer("127.0.0.1")) {
                String string3 = "http://127.0.0.1:4411/eserver/StartInfoCenter?lang=" + string2 + "&filename=" + URL_FILE;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- launchInfoCenter() task is running locally on the HMC.");
                }
                String string4 = "/opt/hsc/bin/hmcBrowserLaunch '" + string3 + "' " + WEB_BROWSER_OPTIONS;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "-- command to launch is <" + string4 + ">");
                }
                eExecResult = EExec.Exec((String)string4);
                if (eExecResult.rc != 0) {
                    if (2 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKF, "-- Error, EExec returned: " + eExecResult.rc);
                        Trace.trace(TRACE_MASKF, "-- stderr is < " + eExecResult.stderr + ">");
                    }
                    SFPUtil.showSFPErrorWindowMessage("0240", HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", "0240", "An error occurred while attempting to launch the eServer Information Center task. View the system event log file for detailed error information and try the operation again."), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "TASK_TITLEBAR_MSG", "Task Information Msg"));
                } else {
                    WizardFrameTasklet.saveWizardStatus(WIZ_STATUS);
                }
            } else if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Warning: The Web Server was not ready in time.");
            }
        }
        catch (Exception exception) {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "-- unexpected exception determining hostname/system locale. e is " + exception);
            }
            SFPUtil.showSFPErrorWindowMessage("0240", HSCResourceBundleUtil.getMessage("SFPResourceBundleMessages", "0240", "An error occurred while attempting to launch the eServer Information Center task. View the system event log file for detailed error information and try the operation again."), HSCResourceBundleUtil.getMessage("SFPResourceBundle", "TASK_TITLEBAR_MSG", "Task Information Msg"));
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- LaunchInfoCenterTask.launchInfoCenter()");
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean waitForWebServer(String string) throws UnknownHostException {
        boolean bl = false;
        Socket socket = null;
        long l = 0L;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> waitForWebServer(" + string + ")");
        }
        l = new GregorianCalendar().getTimeInMillis() + 290000L;
        while (new GregorianCalendar().getTimeInMillis() < l) {
            socket = new Socket();
            socket.connect(new InetSocketAddress(InetAddress.getByName(string), 4411), 10000);
            bl = true;
            Object var7_7 = null;
            if (socket == null) break;
            try {
                socket.close();
            }
            catch (IOException iOException2) {}
            break;
            {
                catch (SocketTimeoutException socketTimeoutException) {
                    var7_7 = null;
                    if (socket == null) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
                catch (IOException iOException) {
                    var7_7 = null;
                    if (socket == null) continue;
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_7 = null;
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- waitForWebServer(...) returning " + bl);
        }
        return bl;
    }
}

